/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware;

public class HwNumber
implements Comparable<HwNumber> {
    long number = 0L;

    public HwNumber(int number) {
        this.setNumber(number);
    }

    public HwNumber(long number) {
        this.setNumber(number);
    }

    public void setNumber(long number) {
        this.number = number;
        this.normalize();
    }

    public long getNumber() {
        return this.number;
    }

    void normalize() {
    }

    public void add(HwNumber op2) {
        this.number += op2.getNumber();
        this.normalize();
    }

    public void sub(HwNumber op2) {
        this.number -= op2.getNumber();
        this.normalize();
    }

    public void mul(HwNumber op2) {
        this.number *= op2.getNumber();
        this.normalize();
    }

    public void div(HwNumber op2) {
        this.number /= op2.getNumber();
        this.normalize();
    }

    public void not() {
        this.number ^= 0xFFFFFFFFFFFFFFFFL;
        this.normalize();
    }

    public void and(HwNumber op2) {
        this.number &= op2.getNumber();
        this.normalize();
    }

    public void or(HwNumber op2) {
        this.number |= op2.getNumber();
        this.normalize();
    }

    public void xor(HwNumber op2) {
        this.number ^= op2.getNumber();
        this.normalize();
    }

    public void shift(int count) {
        if (count > 0) {
            this.number <<= count;
        } else if (count < 0) {
            this.number >>= -count;
        }
        this.normalize();
    }

    public boolean isGreaterThan(HwNumber op2) {
        return this.number > op2.getNumber();
    }

    public boolean isEqualTo(HwNumber op2) {
        return this.number == op2.getNumber();
    }

    public boolean isLessThan(HwNumber op2) {
        return this.number < op2.getNumber();
    }

    public void inc(int i) {
        this.number += (long)i;
        this.normalize();
    }

    public static HwNumber create(int number) {
        HwNumber result = new HwNumber(number);
        return result;
    }

    public void setBit(int bit, boolean val) {
        int mask = 1 << bit;
        this.number = val ? (this.number |= (long)mask) : (this.number &= (long)(~mask));
        this.normalize();
    }

    public boolean getBit(int bit) {
        int mask = 1 << bit;
        return (this.number & (long)mask) != 0L;
    }

    public int hashCode() {
        return Long.valueOf(this.getNumber()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HwNumber) {
            return this.getNumber() == ((HwNumber)obj).getNumber();
        }
        if (obj instanceof Number) {
            return this.getNumber() == ((Number)obj).longValue();
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(HwNumber obj) {
        return Long.signum(this.getNumber() - obj.getNumber());
    }
}

